﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Web_Files_Enhanced
{
    class Misc
    {
        /// <summary>
        /// Determines if a cher is has one of the characters in a specified char array
        /// </summary>
        private static bool ContainsChar(char input, params char[] patterns)
        {
            for (int i = 0; i < patterns.Length; i++)
            {
                if (patterns[i].Equals(input))
                {
                    return true;
                }
            }

            return false;
        }

        private static bool IsCharFileNameSafe(char c)
        {
            char[] safeSymbols = { '-', ' ', '\b', '_', '.' };
            bool isAcceptedSymbol = ContainsChar(c, safeSymbols);

            // if character is alphanumeric and is a safe symbol return true
            return (char.IsLetterOrDigit(c) || isAcceptedSymbol);
        }

        public static string MakeStringFilenameSafe(string text)
        {
            StringBuilder builder = new StringBuilder();

            for (int i = 0; i < text.Length; i++)
            {
                if (IsCharFileNameSafe(text[i]))
                {
                    builder.Append(text[i]);
                }
            }

            return builder.ToString();
        }
    }
}
